#ifndef Path_h
#define Path_h

#include "Map.h"    // Specific to my game
#include <vector.h> // From STL
#include <algo.h>   // From STL

#define ALTITUDE_SCALE (NUM_TERRAIN_TILES/16)
#define MAXIMUM_PATH_LENGTH 100000

// Statistics about the path are kept in this structure
struct PathStats
{
    int nodes_searched;
    int nodes_added;
    int nodes_removed;
    int nodes_visited;
    int nodes_left;
    int path_length;
    int path_cost;
    PathStats()
        :nodes_searched(0), nodes_added(0), nodes_removed(0),
         nodes_visited(0), nodes_left(0),
         path_length(0), path_cost(0)
    {}
};

const int PathCutoff = 15;        // default cutoff
PathStats FindUnitPath( Map& map, HexCoord A, HexCoord B,
                        vector<HexCoord>& path, Unit* unit,
                        int cutoff = PathCutoff );
PathStats FindBuildPath( Map& map, HexCoord A, HexCoord B,
                    vector<HexCoord>& path );
PathStats FindCanalPath( Map& map, HexCoord A, HexCoord B,
                         vector<HexCoord>& path );

int hex_distance( HexCoord a, HexCoord b );
int movement_cost( Map& m, HexCoord a, HexCoord b, Unit* unit );

#endif

